package gov.va.med.mhv.admin.web.validator;

import java.util.ResourceBundle;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "authenticatePatientValidator")
public class AuthenticatePatientValidator implements Validator {

	//private static final Pattern pattern = Pattern.compile("^[A-Za-z][0-9][0-9][0-9][0-9]$");

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String authenticationFacility = null;

		HtmlSelectOneMenu authenticationFacilityValue = (HtmlSelectOneMenu) component.getAttributes()
				.get("authenticationFacility");

		if (authenticationFacilityValue != null && authenticationFacilityValue.getValue() != null) {
			authenticationFacility = (String) authenticationFacilityValue.getValue();
		}

		// fail validation if certain conditions are not met
		if (authenticationFacility == null || authenticationFacility.isEmpty()) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("authenticationFacilityErrorHeader"), ""));
		}
	}
}
